<?php

/**
 * The plugin bootstrap file
 *
 * This file is read by WordPress to generate the plugin information in the plugin
 * admin area. This file also includes all of the dependencies used by the plugin,
 * registers the activation and deactivation functions, and defines a function
 * that starts the plugin.
 *
 * @link              www.acugence.qa
 * @since             1.0.0
 * @package           Agc_Custom_Admin_Data_Table
 *
 * @wordpress-plugin
 * Plugin Name:       Custom admin data table
 * Plugin URI:        www.acugence.qa
 * Description:       This is a short description of what the plugin does. It's displayed in the WordPress admin area.
 * Version:           1.0.0
 * Author:            Acugence
 * Author URI:        www.acugence.qa
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       agc-custom-admin-data-table
 * Domain Path:       /languages
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * Currently plugin version.
 * Start at version 1.0.0 and use SemVer - https://semver.org
 * Rename this for your plugin and update it as you release new versions.
 */
define( 'AGC_CUSTOM_ADMIN_DATA_TABLE_VERSION', '1.0.0' );

/**
 * The code that runs during plugin activation.
 * This action is documented in includes/class-agc-custom-admin-data-table-activator.php
 */
function activate_agc_custom_admin_data_table() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-agc-custom-admin-data-table-activator.php';
	Agc_Custom_Admin_Data_Table_Activator::activate();
}

/**
 * The code that runs during plugin deactivation.
 * This action is documented in includes/class-agc-custom-admin-data-table-deactivator.php
 */
function deactivate_agc_custom_admin_data_table() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-agc-custom-admin-data-table-deactivator.php';
	Agc_Custom_Admin_Data_Table_Deactivator::deactivate();
}

register_activation_hook( __FILE__, 'activate_agc_custom_admin_data_table' );
register_deactivation_hook( __FILE__, 'deactivate_agc_custom_admin_data_table' );

/**
 * The core plugin class that is used to define internationalization,
 * admin-specific hooks, and public-facing site hooks.
 */
require plugin_dir_path( __FILE__ ) . 'includes/class-agc-custom-admin-data-table.php';

/**
 * Begins execution of the plugin.
 *
 * Since everything within the plugin is registered via hooks,
 * then kicking off the plugin from this point in the file does
 * not affect the page life cycle.
 *
 * @since    1.0.0
 */
function run_agc_custom_admin_data_table() {

	$plugin = new Agc_Custom_Admin_Data_Table();
	$plugin->run();

}
run_agc_custom_admin_data_table();
