<?php

/**
 * Define the internationalization functionality
 *
 * Loads and defines the internationalization files for this plugin
 * so that it is ready for translation.
 *
 * @link       www.acugence.qa
 * @since      1.0.0
 *
 * @package    Agc_Custom_Admin_Data_Table
 * @subpackage Agc_Custom_Admin_Data_Table/includes
 */

/**
 * Define the internationalization functionality.
 *
 * Loads and defines the internationalization files for this plugin
 * so that it is ready for translation.
 *
 * @since      1.0.0
 * @package    Agc_Custom_Admin_Data_Table
 * @subpackage Agc_Custom_Admin_Data_Table/includes
 * @author     Acugence <info@acugence.qa>
 */
class Agc_Custom_Admin_Data_Table_i18n {


	/**
	 * Load the plugin text domain for translation.
	 *
	 * @since    1.0.0
	 */
	public function load_plugin_textdomain() {

		load_plugin_textdomain(
			'agc-custom-admin-data-table',
			false,
			dirname( dirname( plugin_basename( __FILE__ ) ) ) . '/languages/'
		);

	}



}
