<?php
/**
 * The template for displaying the footer
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package ice-cream-delights
 */

?>

	<footer id="colophon" class="site-footer">
		<?php if(show_footer_cta()){ ?>
		<div class="container full-bg bottom-melt-blue">
			<div class="row">
				<div class="col-md-6 horizontal-center-align">
					<img class="footer-image" alt="It’s Never Too Cold For Ice Cream" src="<?php echo get_template_directory_uri()?>/img/footer_cta_img.png"/>
				</div>
				<div class="col-md-6 vertical-center-align">
				<div>	
				<h2 class="color-white">It’s<br/>
Never Too Cold <br/>
For Ice Cream</h2>
<div class="cta-holder"><a href="<?php echo get_permalink(220) ?>" class="btn btn-primary">Book now</a></div></div>
				</div>
			</div>
	</div>
	<?php } ?>

	<section class="contact-info">

	<div class="container">
		<div class="row">
			<div class="logo-holder col-12">
			<img class="footer-image" src="<?php echo get_template_directory_uri()?>/img/ice_cream_delights_footer_logo.svg"/>
		</div>
		<div class="address-holder">
		Victoria, Melbourne, 3000
		</div>
		<div class="contact-details">
		<a href="tel:0403 282 328">0403 282 328</a> | <a href="mailto:info@icecreamdelights.com.au">info@icecreamdelights.com.au</a>
		</div>

		<div class="col-12">
<?php
			wp_nav_menu(
				array(
					'theme_location' => 'menu-1',
					'menu_id'        => 'primary-menu-footer',
					'menu_class' => 'navbar-nav ms-auto',
					'add_li_class' => 'nav-item',
					'add_a_class' => 'nav-link',
					'container_class' => 'ms-auto'
				)
			);
			?>
</div>

		<div class="copyright-info col-12">
		Ice Cream Delights © All rights reserved 2022 onwards.
		</div>
		</div>
	</div>
	</section>
	
	</footer><!-- #colophon -->
</div><!-- #page -->


<?php wp_footer(); ?>
</body>
</html>
