<?php
/**
 * Template part for displaying page content in page.php
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package ice-cream-delights
 */

?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	<header class="entry-header style-1 booking">
		<?php the_title( '<h1 class="entry-title color-white">', '</h1>' ); ?>
	</header><!-- .entry-header -->

	<?php ice_cream_delights_post_thumbnail(); ?>

	<div class="entry-content" style="perspective: 2810px;">
		<div class="color-white text-center">
		<?php
		the_content();

		wp_link_pages(
			array(
				'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'ice-cream-delights' ),
				'after'  => '</div>',
			)
		);
		?>
		</div>
		<div class="book-header-image"></div>
		<form class="booking-form bottom-melt-white" method="POST" data-process-form>
		
		<div class="row booking-success">
			<div class="col-md-12 text-center">
					<img src="<?php echo get_template_directory_uri()?>/img/booking_final_img.jpg"/>
			</div>
			<div class="col-md-12 text-center">
				<h5>We'll get back to you soon.<br/>For more enquiries please reach us at <a href="tel:0403 282 328">0403 282 328</a> or <a href="mailto:info@icecreamdelights.com.au">info@icecreamdelights.com.au</a>
		</div>
		</div>

		<div class="row form-row">
			<div class="col-md-6 form-item">
				<input type="text" placeholder="Full name *" class="form-control" name="name"/>
				<div class="invalid-feedback">Please enter a valid name.</div>
			</div>
			<div class="col-md-6 form-item"><input type="email" class="form-control" placeholder="Email address *" name="email"/>
			<div class="invalid-feedback">Please enter a valid email.</div>
		</div>
		</div>
		
		<div class="row form-row">
			<div class="col-md-6 form-item"><input type="tel" class="form-control" placeholder="Contact number" name="phone"/>
			<div class="invalid-feedback">Please enter a valid phone number.</div>
		</div>
			<div class="col-md-6 form-item"><input type="text" class="form-control" name="company" placeholder="Company"/>
		</div>
		</div>
		<input type="hidden" name="form_type" value="book_van"/>
		<div class="row form-row">
			<div class="col-md-6 form-item">
				<select class="form-control" name="event">
					<option value="">Event type</option>
					<option value="Market">Market</option>
					<option value="Fete">Fete</option>
					<option value="Fundraising">Fundraising</option>
					<option value="School">School</option>
					<option value="Corporate">Coporate</option>
					<option value="Private Function">Private&nbsp;Function</option>
					<option value="BBQ">Wedding</option>
					<option value="Agricultural Shows">Agricultural&nbsp;Shows</option>
				</select>
				
			</div>
			<div class="col-md-6 form-item"><input type="datetime-local" class="form-control" placeholder="Date & time" name="date_time"/>
			<div class="invalid-feedback">Please enter a valid date & time.</div>
		</div>
		</div>

		<div class="row form-row">
			<div class="col-12 form-item"><textarea class="form-control" placeholder="Address" name="address"></textarea>
		</div>
		</div>

		<div class="row form-row">
			<div class="col-md-6 form-item"><input type="text" class="form-control" placeholder="Suburb" name="suburb"/></div>
			<div class="col-md-6 form-item"><input type="text" class="form-control" name="state" value="VIC Only" disabled="disabled"/></div>
		</div>
		
		<div class="row form-row">
			<div class="col-md-6 form-item"><input type="text" class="form-control" name="postcode" placeholder="Postcode"/></div>
			<div class="col-md-6 form-item">
				<select class="form-control" name="power_available">
					<option value="">Power availability</option>
					<option value="Yes">Yes</option>
					<option value="No">No</option>
				</select>
			</div>
		</div>

		<div class="row form-row">
			<div class="col-md-6 form-item"><input type="number" class="form-control" name="no_attending" placeholder="No. attending"/></div>
			<div class="col-md-6 form-item"><input type="text" class="form-control" name="how_did_hear" placeholder="How did you hear about us?"/></div>
		</div>

		<div class="row form-row">
		<div class="col-12 form-item"><textarea class="form-control" placeholder="Additional event details" name="event_details"></textarea></div>
		</div>
		<h5 class="form-row">Select products</h5>
		<div class="row form-row checkbox-holder">
		<div class="form-check col-md-4 col-lg-3">
			<input class="form-check-input" type="checkbox" name ="products[]" value="Soft Serve" id="product_1">
			<label class="form-check-label" for="product_1">Soft Serve</label>
		</div>
		<div class="form-check col-md-4 col-lg-3">
			<input class="form-check-input" type="checkbox" name ="products[]" value="Hot Dogs" id="product_2">
			<label class="form-check-label" for="product_2">Hot Dogs</label>
		</div>
		<div class="form-check col-md-4 col-lg-3">
			<input class="form-check-input" type="checkbox" name ="products[]" value="Popcorn" id="product_3">
			<label class="form-check-label" for="product_3">Popcorn</label>
		</div>
		<div class="form-check col-md-4 col-lg-3">
			<input class="form-check-input" type="checkbox" name ="products[]" value="Fairy Floss" id="product_4">
			<label class="form-check-label" for="product_4">Fairy Floss</label>
		</div>
		<div class="form-check col-md-4 col-lg-3">
			<input class="form-check-input" type="checkbox" name ="products[]" value="Drinks" id="product_5">
			<label class="form-check-label" for="product_5">Drinks</label>
		</div>
		<div class="form-check col-md-4 col-lg-3">
			<input class="form-check-input" type="checkbox" name ="products[]" value="Gelati" id="product_6">
			<label class="form-check-label" for="product_6">Gelati</label>
		</div>
		<div class="form-check col-md-4 col-lg-3">
			<input class="form-check-input" type="checkbox" name ="products[]" value="Slushie" id="product_7">
			<label class="form-check-label" for="product_7">Slushie</label>
		</div>
		<!--<div class="form-check col-md-4 col-lg-3">
			<input class="form-check-input" type="checkbox" name ="products[]" value="Hot Jam Donuts" id="product_8">
			<label class="form-check-label" for="product_8">Jam Donuts</label>
		</div>-->
	</div>
	<div class="row form-row">
		<div class="col-md-12">
			<div class="row">
					<input type="submit" value="Book your van" name="submit_booking" class="btn btn-primary col-12"/>
					<div class="alert alert-danger" role="alert" style="  display:none;
    border-radius: 8px;
    text-align: center;
    margin-top: 20px;
">
  Sorry, there was an error. For time being, for booking please reach us at <a href="tel:0403 282 328">0403 282 328</a> or <a href="mailto:info@icecreamdelights.com.au">info@icecreamdelights.com.au</a>
</div>
			</div>
			
		</div>
	</div>


		</form>

	</div><!-- .entry-content -->

	<?php if ( get_edit_post_link() ) : ?>
		<footer class="entry-footer">
			<?php
			edit_post_link(
				sprintf(
					wp_kses(
						/* translators: %s: Name of current post. Only visible to screen readers */
						__( 'Edit <span class="screen-reader-text">%s</span>', 'ice-cream-delights' ),
						array(
							'span' => array(
								'class' => array(),
							),
						)
					),
					wp_kses_post( get_the_title() )
				),
				'<span class="edit-link">',
				'</span>'
			);
			?>
		</footer><!-- .entry-footer -->
	<?php endif; ?>
</article><!-- #post-<?php the_ID(); ?> -->
